/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ptmp.filter.impl;

import com.cisco.pt.ptmp.filter.Filter;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZlibCompressionFilter
implements Filter {
    private static Log logger = LogFactory.getLog(ZlibCompressionFilter.class);

    public byte[] out(byte[] bytes) {
        byte[] output = null;
        ByteBuffer buff = ByteBuffer.allocate(8192);
        int length = 0;
        byte[] temp = new byte[8192];
        if (logger.isInfoEnabled()) {
            logger.info((Object)("attempting compress bytes of length: [" + bytes.length + "]"));
        }
        if (bytes != null) {
            length = bytes.length;
            Deflater compresser = new Deflater();
            compresser.setInput(bytes);
            compresser.finish();
            int newlength = compresser.deflate(temp);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("compressed to length bytes: [" + newlength + "]"));
            }
            buff.putInt(length);
            buff.put(temp, 0, newlength);
            output = new byte[buff.position()];
            buff.flip();
            buff.get(output);
        }
        return output;
    }

    public byte[] in(byte[] bytes) {
        byte[] output = null;
        ByteBuffer buff = ByteBuffer.allocate(8192);
        int length = 0;
        if (bytes != null) {
            buff.put(bytes);
            buff.flip();
            length = buff.getInt();
            int compLength = buff.limit() - buff.position();
            if (length > 0 && compLength > 0) {
                byte[] temp = new byte[compLength];
                buff.get(temp);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("attempting inflating bytes of length: [" + bytes.length + "]"));
                }
                try {
                    output = new byte[length];
                    Inflater decompresser = new Inflater();
                    decompresser.setInput(temp);
                    int newlength = decompresser.inflate(output);
                    decompresser.end();
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("inflated to length bytes: [" + newlength + "]"));
                    }
                }
                catch (DataFormatException dfe) {
                    logger.error((Object)dfe.getMessage(), (Throwable)dfe);
                }
            }
        }
        return output;
    }
}

